MODULE FatalError

  IMPLICIT NONE
  INTEGER, PRIVATE :: PRTFile = 6

  CONTAINS
  SUBROUTINE ERROUT( WHERE, ErrMsg )

    !     Outputs an error message

    !     WHERE  in which program or subroutine
    !     ErrMsg error message

    CHARACTER (LEN=*), INTENT( IN ) :: WHERE, ErrMsg
    INTEGER   Last

    WRITE( PRTFile, * )
    WRITE( PRTFile, * ) '*** FATAL ERROR ***'

    Last = LEN( WHERE )
    WRITE( PRTFile, * ) 'Generated by program or subroutine: ', WHERE( 1 : Last )

    Last = LEN( ErrMsg )
    WRITE( PRTFile, * ) ErrMsg( 1 : Last )
    WRITE( PRTFile, * )
    CLOSE( PRTFile )

    ! Intel Fortran can't handle the following
    ! ERROR STOP 'Fatal Error in ' // WHERE( 1 : Last1 ) // ': ' // ErrMsg( 1 : Last2 )
    STOP 'Fatal Error: Check the print file for details'

  END SUBROUTINE ERROUT

END MODULE FatalError
